<?php

/* --------------------------------------------------------------
   ContentSitemapInterface.inc.inc.php 2019-04-11
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

/**
 * Interface ContentSitemapInterface
 *
 * @category   System
 * @package    Content
 * @subpackage Interfaces
 */
interface ContentSitemapInterface
{
    /**
     * Return whether the content is visible in the site map
     *
     * @return bool
     */
    public function isVisible(): bool;
    
    
    /**
     * Return the site map content priority collection
     *
     * @return ContentSitemapPriorityCollection
     */
    public function priorities(): ContentSitemapPriorityCollection;
    
    
    /**
     * Return the change frequency of the content
     *
     * @return string
     */
    public function frequencyOfChange(): string;
}